#if !defined(__leowl_2_h)              // Sentry, use file only if it's not already included.
#define __leowl_2_h

/*  Project leowl_2
	 xor@frognet.net
	 Copyright  1996. Andrey B. Yastrebov. All Rights Reserved.

	 SUBSYSTEM:    leowl_2.exe Application
	 FILE:         leowl_2.h
	 AUTHOR:       Andrey B. Yastrebov


	 OVERVIEW
	 ========
	 Class definition for leowl_2 (TApplication).
*/


#include <owl\owlpch.h>
#include <owl\statusba.h>
#include <owl\controlb.h>
#include <owl\buttonga.h>
#pragma hdrstop

#include <classlib\bags.h>

#include "leowl_2c.h"

#include "leowl_2.rh"            // Definition of all resources.


// TFileDrop class Maintains information about a dropped file, its name, where it was dropped,
// and whether or not it was in the client area
class TFileDrop {
public:
    operator == (const TFileDrop& other) const {return this == &other;}

    char*   FileName;
    TPoint  Point;
    BOOL    InClientArea;

    TFileDrop (char*, TPoint&, BOOL, TModule*);
    ~TFileDrop ();

    const char* WhoAmI ();
private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TFileDrop (const TFileDrop&);
    TFileDrop & operator = (const TFileDrop&);
};

typedef TIBagAsVector<TFileDrop> TFileList;
typedef TIBagAsVectorIterator<TFileDrop> TFileListIter;


//{{TApplication = leowl_2}}
class leowl_2 : public TApplication {
private:

    void AddFiles (TFileList* files);

public:
    leowl_2 ();
    virtual ~leowl_2 ();

    leowl_2MDIClient  *mdiClient;

//{{leowl_2VIRTUAL_BEGIN}}
public:
    virtual void InitMainWindow();
    virtual void InitInstance();
	 virtual BOOL CanClose ();
//{{leowl_2VIRTUAL_END}}

//{{leowl_2RSP_TBL_BEGIN}}
protected:
    void CmHelpAbout ();
    void EvDropFiles (TDropInfo drop);
    void CmDesktopRestore ();
    void CmDesktopSave ();
//{{leowl_2RSP_TBL_END}}
DECLARE_RESPONSE_TABLE(leowl_2);
DECLARE_STREAMABLE(,leowl_2,1);
};    //{{leowl_2}}


#endif                                      // __leowl_2_h sentry.
